﻿<?php
// ARQUIVO: salvar_notas_ajax.php (Novo arquivo)
header('Content-Type: application/json');

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once "conexao.php"; // Garanta que a conexão e segurança estejam incluídas

// Verifica se os dados foram enviados via JSON
$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);

if (!isset($data['autosave']) || !$data['autosave']) {
    // Bloqueia se não for uma requisição de salvamento automático
    echo json_encode(['success' => false, 'message' => 'Acesso negado.']);
    exit;
}

// Extrair dados de contexto
$turma_id = (int)($data['turma_id'] ?? 0);
$disciplina_id = (int)($data['disciplina_id'] ?? 0);
$trimestre_selecionado = (int)($data['trimestre'] ?? 0);
$data_lancamento_agora = date('Y-m-d H:i:s');
$ano_lectivo_atual = date('Y');

if ($turma_id === 0 || $disciplina_id === 0 || $trimestre_selecionado === 0) {
    echo json_encode(['success' => false, 'message' => 'Filtros incompletos.']);
    exit;
}

$conn->begin_transaction();
$sucesso = true;
$aluno_processado = [];

foreach ($data as $key => $value) {
    // Padrão para NPT, NPP (Trimestral) ou NEO, NEE (Final)
    if (preg_match('/^(npt|npp)_(\d+)_(\d+)$/', $key, $matches_trimestre) || 
        preg_match('/^(neo|nee)_(\d+)$/', $key, $matches_final)) {
        
        $aluno_id = (int)($matches_trimestre[3] ?? $matches_final[2]);
        $tipo_nota = $matches_trimestre[1] ?? $matches_final[1];
        
        // Converte string vazia para null (para limpeza de nota)
        $nota_valor = ($value === '') ? null : (float)max(0, min(20, $value)); 
        
        if (!in_array($aluno_id, $aluno_processado)) {
            // Prepara a atualização/inserção de todas as notas trimestrais/finais deste aluno de uma vez.
            // Para isso, você precisa de uma função que:
            // 1. Busca todas as notas MAC, NPP, NPT (Trimestral) OU NEO, NEE (Final)
            // 2. Calcula novamente MT (ou MEC/MF)
            // 3. Salva todas as notas relacionadas à linha do aluno.
            
            // --- SIMPLIFICAÇÃO: Apenas salvando o valor individualmente por agora ---
            
            $coluna = $tipo_nota;
            $trimestre_db = ($tipo_nota === 'neo' || $tipo_nota === 'nee') ? 3 : $trimestre_selecionado;

            $sql = "
                INSERT INTO notas (aluno_id, turma_id, disciplina_id, trimestre, {$coluna}, data_lancamento, ano_lectivo)
                VALUES (?, ?, ?, ?, ?, ?, ?)
                ON DUPLICATE KEY UPDATE
                    {$coluna}=VALUES({$coluna}),
                    data_lancamento=VALUES(data_lancamento)
            ";
            
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("iiiidss", 
                $aluno_id, 
                $turma_id, 
                $disciplina_id, 
                $trimestre_db, 
                $nota_valor, 
                $data_lancamento_agora, 
                $ano_lectivo_atual
            );
            
            if (!$stmt->execute()) {
                $sucesso = false;
                error_log("AJAX Erro ao salvar {$coluna} (aluno $aluno_id): " . $stmt->error);
            }
            $stmt->close();
            
            // Aqui você deve adicionar a lógica para RECALCULAR MT/MF para garantir consistência
            // ... (Chame uma função de recálculo de MT/MF no PHP) ...
        }
    }
}

if ($sucesso) {
    $conn->commit();
    echo json_encode(['success' => true, 'message' => 'Notas salvas com sucesso.']);
} else {
    $conn->rollback();
    echo json_encode(['success' => false, 'message' => 'Erro ao salvar uma ou mais notas.']);
}
?>